package com.example.canal.config;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * RabbitMQ配置类
 * 
 * @author YourName
 * @since 2023-XX-XX
 */
@Configuration
public class RabbitMQConfig {
    
    // 交换器名称
    public static final String EXCHANGE_NAME = "canal.data.sync.exchange";
    
    // 队列名称
    public static final String QUEUE_NAME = "canal.data.sync.queue";
    
    // 路由键
    public static final String ROUTING_KEY = "canal.data.sync.routing.key";
    
    /**
     * 创建交换器
     * 
     * @return DirectExchange
     */
    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange(EXCHANGE_NAME, true, false);
    }
    
    /**
     * 创建队列
     * 
     * @return Queue
     */
    @Bean
    public Queue queue() {
        return new Queue(QUEUE_NAME, true);
    }
    
    /**
     * 绑定交换器和队列
     * 
     * @param queue 队列
     * @param exchange 交换器
     * @return Binding
     */
    @Bean
    public Binding binding(Queue queue, DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(ROUTING_KEY);
    }
    
    /**
     * 配置RabbitTemplate
     * 
     * @param connectionFactory 连接工厂
     * @return RabbitTemplate
     */
    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setMessageConverter(jsonMessageConverter());
        return template;
    }
    
    /**
     * 配置JSON消息转换器
     * 
     * @return MessageConverter
     */
    @Bean
    public MessageConverter jsonMessageConverter() {
        return new Jackson2JsonMessageConverter();
    }
}