package com.example.canal.config;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.net.InetSocketAddress;

/**
 * Canal配置类
 * 
 * @author YourName
 * @since 2023-XX-XX
 */
@Configuration
public class CanalConfig {
    
    @Value("${canal.client.hostname}")
    private String hostname;
    
    @Value("${canal.client.port}")
    private int port;
    
    @Value("${canal.client.destination}")
    private String destination;
    
    @Value("${canal.client.username}")
    private String username;
    
    @Value("${canal.client.password}")
    private String password;
    
    /**
     * 创建Canal连接器
     * 
     * @return CanalConnector
     */
    @Bean
    public CanalConnector canalConnector() {
        // 创建单机版连接器
        CanalConnector connector = CanalConnectors.newSingleConnector(
                new InetSocketAddress(hostname, port), 
                destination, 
                username, 
                password);
        
        // 连接Canal服务器
        connector.connect();
        
        // 订阅所有数据库和表的变更
        connector.subscribe(".*\\..*");
        
        // 回滚到未进行ack的位置
        connector.rollback();
        
        return connector;
    }
}