package com.example.customer.controller;

import com.example.customer.service.IntelligentCustomerService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/api/customer-service")
public class CustomerServiceController {
    
    private final IntelligentCustomerService customerService;
    
    public CustomerServiceController(IntelligentCustomerService customerService) {
        this.customerService = customerService;
    }
    
    @PostMapping("/ask")
    public ResponseEntity<String> askQuestion(@RequestBody QuestionRequest request) {
        try {
            String answer = customerService.getAnswer(request.getQuestion());
            return ResponseEntity.ok(answer);
        } catch (Exception e) {
            return ResponseEntity.status(500).body("处理问题时发生错误：" + e.getMessage());
        }
    }
    
    @PostMapping("/knowledge-base/add")
    public ResponseEntity<String> addKnowledge(@RequestBody KnowledgeRequest request) {
        try {
            Map<String, Object> metadata = Map.of(
                "source", request.getSource(),
                "category", request.getCategory(),
                "timestamp", System.currentTimeMillis()
            );
            
            customerService.addDocument(request.getContent(), metadata);
            return ResponseEntity.ok("知识库更新成功");
        } catch (Exception e) {
            return ResponseEntity.status(500).body("添加知识时发生错误：" + e.getMessage());
        }
    }
    
    @DeleteMapping("/knowledge-base/remove/{id}")
    public ResponseEntity<String> removeKnowledge(@PathVariable String id) {
        try {
            customerService.removeDocument(id);
            return ResponseEntity.ok("知识库内容删除成功");
        } catch (Exception e) {
            return ResponseEntity.status(500).body("删除知识时发生错误：" + e.getMessage());
        }
    }
}

// 请求对象
class QuestionRequest {
    private String question;
    
    public String getQuestion() {
        return question;
    }
    
    public void setQuestion(String question) {
        this.question = question;
    }
}

class KnowledgeRequest {
    private String content;
    private String source;
    private String category;
    
    public String getContent() {
        return content;
    }
    
    public void setContent(String content) {
        this.content = content;
    }
    
    public String getSource() {
        return source;
    }
    
    public void setSource(String source) {
        this.source = source;
    }
    
    public String getCategory() {
        return category;
    }
    
    public void setCategory(String category) {
        this.category = category;
    }
}