package com.example.customer.config;

import com.example.customer.service.IntelligentCustomerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Component
public class KnowledgeBaseInitializer implements ApplicationRunner {
    
    private final IntelligentCustomerService customerService;
    
    @Autowired
    public KnowledgeBaseInitializer(IntelligentCustomerService customerService) {
        this.customerService = customerService;
    }
    
    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 初始化知识库，添加常见问题
        initializeKnowledgeBase();
    }
    
    private void initializeKnowledgeBase() {
        // 示例FAQ数据
        List<String> faqData = Arrays.asList(
            "Q: 你们的产品支持退款吗？\nA: 我们提供7天无理由退款服务，详情请查看退款政策。",
            "Q: 如何联系客服？\nA: 您可以通过在线客服、邮件或电话联系我们的客服团队。",
            "Q: 产品有哪些功能？\nA: 我们的产品包含功能A、功能B和功能C，具体请查看产品介绍页面。",
            "Q: 如何重置密码？\nA: 您可以在登录页面点击'忘记密码'链接，按照提示操作即可重置密码。",
            "Q: 支持哪些支付方式？\nA: 我们支持支付宝、微信支付、银行卡等多种支付方式。",
            "Q: 服务的响应时间是多少？\nA: 我们的服务响应时间通常在1秒以内，保障快速响应。",
            "Q: 是否支持移动端？\nA: 是的，我们的服务完全支持移动端，提供原生APP和H5页面。",
            "Q: 如何升级到高级版？\nA: 您可以在个人中心选择升级套餐，按照提示完成支付即可。"
        );
        
        for (int i = 0; i < faqData.size(); i++) {
            String content = faqData.get(i);
            Map<String, Object> metadata = Map.of(
                "type", "faq",
                "priority", i,
                "category", "customer-service"
            );
            
            customerService.addDocument(content, metadata);
        }
        
        System.out.println("知识库初始化完成，共添加 " + faqData.size() + " 条FAQ");
    }
}