# SpringBoot + Ollama + RAG 智能客服系统

基于SpringBoot、Ollama和RAG（检索增强生成）技术构建的私有化部署智能客服系统。

## 功能特性

- 本地大模型运行，保障数据安全
- RAG技术增强回答准确性
- 知识库动态更新
- RESTful API接口
- Docker容器化部署

## 技术栈

- Spring Boot 3.2+
- Ollama
- Spring AI
- Redis（向量存储）
- Llama 3模型

## 快速开始

### 环境要求

- Java 17+
- Maven 3.8+
- Docker & Docker Compose
- Redis
- Ollama

### 本地运行

1. 启动Ollama服务：
   ```bash
   ollama serve
   ```

2. 拉取所需模型：
   ```bash
   ollama pull llama3
   ollama pull nomic-embed-text
   ```

3. 启动Redis服务：
   ```bash
   docker run -d -p 6379:6379 --name redis redis:7-alpine
   ```

4. 构建并运行项目：
   ```bash
   mvn clean package
   mvn spring-boot:run
   ```

### Docker Compose部署

```bash
docker-compose up -d
```

## API接口

### 询问问题
```
POST /api/customer-service/ask
Content-Type: application/json

{
  "question": "你们的产品支持退款吗？"
}
```

### 添加知识库
```
POST /api/customer-service/knowledge-base/add
Content-Type: application/json

{
  "content": "Q: 如何联系客服？\nA: 您可以通过在线客服、邮件或电话联系我们的客服团队。",
  "source": "faq",
  "category": "customer-service"
}
```

### 删除知识库
```
DELETE /api/customer-service/knowledge-base/remove/{id}
```

## 项目结构

```
src/
├── main/
│   ├── java/com/example/customer/
│   │   ├── CustomerServiceApplication.java    # 主应用类
│   │   ├── controller/                        # 控制器层
│   │   │   └── CustomerServiceController.java
│   │   ├── service/                           # 服务层
│   │   │   └── IntelligentCustomerService.java
│   │   └── config/                            # 配置类
│   │       └── KnowledgeBaseInitializer.java
│   └── resources/
│       └── application.yml                    # 配置文件
docker/                                       # Docker相关文件
├── Dockerfile
├── start.sh
docker-compose.yml                            # Docker Compose配置
pom.xml                                       # Maven依赖配置
README.md                                     # 项目说明
```

## 配置说明

- `spring.ai.ollama.base-url`: Ollama服务地址
- `spring.ai.ollama.chat.options.model`: 聊天模型名称
- `spring.ai.embedding.ollama.options.model`: 嵌入模型名称
- `spring.ai.vectorstore.redis.index-name`: Redis向量索引名

## 性能优化建议

1. 根据硬件资源选择合适的模型大小
2. 使用Redis或Milvus等高性能向量数据库
3. 对常见问题的回答进行缓存
4. 使用负载均衡器实现高可用

## 注意事项

- 确保有足够的内存来运行大模型
- 根据实际需求调整模型参数
- 生产环境需配置安全认证机制