package com.example.aviator.entity;

import lombok.Data;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 规则实体类
 */
@Entity
@Table(name = "t_rule")
@Data
public class Rule {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    /**
     * 规则编码
     */
    @Column(unique = true, nullable = false)
    private String ruleCode;
    
    /**
     * 规则名称
     */
    private String ruleName;
    
    /**
     * 规则表达式
     */
    @Lob
    private String ruleExpression;
    
    /**
     * 规则描述
     */
    private String description;
    
    /**
     * 规则类型
     */
    private String ruleType;
    
    /**
     * 是否启用
     */
    private Boolean enabled = true;
    
    /**
     * 版本号
     */
    private Integer version = 1;
    
    /**
     * 创建时间
     */
    private LocalDateTime createTime = LocalDateTime.now();
    
    /**
     * 更新时间
     */
    private LocalDateTime updateTime = LocalDateTime.now();
}