package com.example.datamasking.util;

/**
 * 敏感信息类型枚举
 */
public enum SensitiveTypeEnum {
    /**
     * 中文姓名脱敏（保留姓氏，其余用*代替）
     * 示例：张三 -> 张*
     */
    CHINESE_NAME(1, "中文姓名"),

    /**
     * 身份证号码脱敏（保留前3位和后3位）
     * 示例：110101199003071234 -> 110****1234
     */
    ID_CARD(2, "身份证号码"),

    /**
     * 手机号码脱敏（保留前3位和后4位）
     * 示例：13812345678 -> 138****5678
     */
    PHONE(3, "手机号码"),

    /**
     * 固定电话脱敏（保留区号和后4位）
     * 示例：010-12345678 -> 010****5678
     */
    FIXED_PHONE(4, "固定电话"),

    /**
     * 电子邮件脱敏（保留用户名首尾各1位）
     * 示例：example@domain.com -> e***e@domain.com
     */
    EMAIL(5, "电子邮件"),

    /**
     * 银行卡号脱敏（保留前6位和后4位）
     * 示例：6222021234567890123 -> 622202******90123
     */
    BANK_CARD(6, "银行卡号"),

    /**
     * 地址脱敏（保留前6位字符）
     * 示例：北京市朝阳区某某街道123号 -> 北京市朝阳区******
     */
    ADDRESS(7, "地址"),

    /**
     * 自定义脱敏规则
     */
    CUSTOM(8, "自定义");

    private final int code;
    private final String description;

    SensitiveTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}