package com.example.datamasking.entity;

import com.example.datamasking.annotation.SensitiveData;
import com.example.datamasking.util.SensitiveTypeEnum;

/**
 * 用户信息实体类
 */
public class UserInfo {
    
    private Long id;
    
    @SensitiveData(type = SensitiveTypeEnum.CHINESE_NAME)
    private String name;
    
    @SensitiveData(type = SensitiveTypeEnum.ID_CARD)
    private String idCard;
    
    @SensitiveData(type = SensitiveTypeEnum.PHONE)
    private String phone;
    
    @SensitiveData(type = SensitiveTypeEnum.EMAIL)
    private String email;
    
    @SensitiveData(type = SensitiveTypeEnum.ADDRESS)
    private String address;
    
    @SensitiveData(type = SensitiveTypeEnum.BANK_CARD)
    private String bankCard;
    
    // 自定义脱敏示例：保留前2位，后1位
    @SensitiveData(type = SensitiveTypeEnum.CUSTOM, prefixKeep = 2, suffixKeep = 1, maskChar = "*")
    private String licensePlate;
    
    public UserInfo() {
    }
    
    public UserInfo(Long id, String name, String idCard, String phone, String email, String address, String bankCard, String licensePlate) {
        this.id = id;
        this.name = name;
        this.idCard = idCard;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.bankCard = bankCard;
        this.licensePlate = licensePlate;
    }
    
    // getter和setter方法
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public String getIdCard() {
        return idCard;
    }
    
    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    
    public String getPhone() {
        return phone;
    }
    
    public void setPhone(String phone) {
        this.phone = phone;
    }
    
    public String getEmail() {
        return email;
    }
    
    public void setEmail(String email) {
        this.email = email;
    }
    
    public String getAddress() {
        return address;
    }
    
    public void setAddress(String address) {
        this.address = address;
    }
    
    public String getBankCard() {
        return bankCard;
    }
    
    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    
    public String getLicensePlate() {
        return licensePlate;
    }
    
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    
    @Override
    public String toString() {
        return "UserInfo{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", idCard='" + idCard + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", address='" + address + '\'' +
                ", bankCard='" + bankCard + '\'' +
                ", licensePlate='" + licensePlate + '\'' +
                '}';
    }
}