package com.example.datamasking.controller;

import com.example.datamasking.entity.UserInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户信息控制器 - 演示数据脱敏功能
 */
@RestController
@RequestMapping("/api/user")
public class UserController {

    /**
     * 获取用户信息 - 演示单个对象脱敏
     */
    @GetMapping("/info")
    public UserInfo getUserInfo() {
        return new UserInfo(
                1L,
                "张三丰",                    // 中文姓名脱敏：张**
                "110101199003071234",       // 身份证脱敏：110****1234
                "13812345678",              // 手机号脱敏：138****5678
                "zhangsanfeng@example.com", // 邮箱脱敏：z****g@...
                "北京市朝阳区某某街道123号",     // 地址脱敏：北京市朝阳区******
                "6222021234567890123",      // 银行卡脱敏：622202******90123
                "京A88888"                  // 自定义脱敏：京A888*
        );
    }

    /**
     * 获取用户列表 - 演示集合对象脱敏
     */
    @GetMapping("/list")
    public List<UserInfo> getUserList() {
        List<UserInfo> userList = new ArrayList<>();
        userList.add(new UserInfo(
                1L,
                "张三",
                "110101199001011234",
                "13800138000",
                "zhangsan@example.com",
                "北京市海淀区中关村大街1号",
                "6222021234567890001",
                "京A12345"
        ));
        userList.add(new UserInfo(
                2L,
                "李四",
                "110101199002022345",
                "13900139000",
                "lisi@example.com",
                "上海市浦东新区陆家嘴环路1000号",
                "6222021234567890002",
                "沪B67890"
        ));
        return userList;
    }

    /**
     * 获取用户信息Map - 演示Map对象脱敏
     */
    @GetMapping("/map")
    public Map<String, UserInfo> getUserMap() {
        Map<String, UserInfo> userMap = new HashMap<>();
        userMap.put("user1", new UserInfo(
                1L,
                "王五",
                "110101199005053456",
                "13700137000",
                "wangwu@example.com",
                "广州市天河区珠江新城花城大道123号",
                "6222021234567890003",
                "粤C11111"
        ));
        userMap.put("user2", new UserInfo(
                2L,
                "赵六",
                "110101199006064567",
                "13600136000",
                "zhaoliu@example.com",
                "深圳市南山区科技园南区123号",
                "6222021234567890004",
                "深D22222"
        ));
        return userMap;
    }

    /**
     * 获取用户详细信息 - 演示嵌套对象脱敏
     */
    @GetMapping("/detail")
    public Map<String, Object> getUserDetail() {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 200);
        result.put("message", "success");
        result.put("data", new UserInfo(
                1L,
                "欧阳修",
                "110101199007075678",
                "13500135000",
                "ouyangxiu@example.com",
                "杭州市西湖区文三路259号",
                "6222021234567890005",
                "浙F33333"
        ));
        return result;
    }
}