package com.example.datamasking.annotation;

import com.example.datamasking.util.SensitiveTypeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 敏感数据脱敏注解
 * 用于标记需要脱敏的字段
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface SensitiveData {

    /**
     * 脱敏类型
     */
    SensitiveTypeEnum type() default SensitiveTypeEnum.CUSTOM;

    /**
     * 前缀保留长度（自定义脱敏时使用）
     */
    int prefixKeep() default 0;

    /**
     * 后缀保留长度（自定义脱敏时使用）
     */
    int suffixKeep() default 0;

    /**
     * 替换字符
     */
    String maskChar() default "*";

    /**
     * 是否启用脱敏
     */
    boolean enabled() default true;
}