# SpringBoot-Data-Masking-Demo

## 项目简介

这是一个基于Spring Boot的数据脱敏演示项目，通过自定义注解和AOP切面实现数据脱敏功能。

## 技术栈

- Spring Boot 2.7.0
- Spring AOP
- Maven

## 功能特性

1. **多种脱敏类型**：支持中文姓名、身份证、手机号、邮箱、地址、银行卡等多种敏感信息脱敏
2. **自定义脱敏规则**：支持自定义前缀保留、后缀保留和替换字符
3. **注解驱动**：通过`@SensitiveData`注解标记需要脱敏的字段
4. **AOP自动处理**：无需修改业务代码，通过AOP自动处理返回数据
5. **嵌套对象支持**：支持对嵌套对象、集合、Map等复杂数据结构进行脱敏

## 使用方法

### 1. 添加脱敏注解

在实体类的敏感字段上添加`@SensitiveData`注解：

```java
public class UserInfo {
    @SensitiveData(type = SensitiveTypeEnum.CHINESE_NAME)
    private String name;
    
    @SensitiveData(type = SensitiveTypeEnum.PHONE)
    private String phone;
    
    @SensitiveData(type = SensitiveTypeEnum.CUSTOM, prefixKeep = 2, suffixKeep = 1)
    private String licensePlate;
}
```

### 2. 访问接口查看效果

启动项目后访问以下接口：

- `GET /api/user/info` - 获取单个用户信息
- `GET /api/user/list` - 获取用户列表
- `GET /api/user/map` - 获取用户Map
- `GET /api/user/detail` - 获取用户详细信息

## 脱敏类型说明

- `CHINESE_NAME`：中文姓名（保留姓氏，其余用*代替）
- `ID_CARD`：身份证号码（保留前3位和后3位）
- `PHONE`：手机号码（保留前3位和后4位）
- `EMAIL`：电子邮件（保留用户名首尾各1位）
- `ADDRESS`：地址（保留前6位字符）
- `BANK_CARD`：银行卡号（保留前6位和后4位）
- `CUSTOM`：自定义脱敏规则

## 核心实现

1. **SensitiveDataAspect**：AOP切面，拦截控制器方法返回值
2. **SensitiveDataHandler**：脱敏处理器，提供各种脱敏算法
3. **SensitiveData**：脱敏注解，标记需要脱敏的字段
4. **SensitiveTypeEnum**：脱敏类型枚举

## 项目结构

```
src/main/java/com/example/datamasking
├── annotation        # 注解定义
│   └── SensitiveData.java
├── aspect           # AOP切面
│   └── SensitiveDataAspect.java
├── util             # 工具类
│   ├── SensitiveDataHandler.java
│   └── SensitiveTypeEnum.java
├── entity           # 实体类
│   └── UserInfo.java
├── controller       # 控制器
│   └── UserController.java
└── DataMaskingApplication.java  # 启动类
```