package com.example.shardingsphere.service;

import com.example.shardingsphere.entity.Order;
import com.example.shardingsphere.mapper.OrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class OrderService {
    
    @Autowired
    private OrderMapper orderMapper;
    
    public void createOrder(Order order) {
        // When this method is called, ShardingSphere will automatically route to the correct database and table
        // based on the user_id according to the sharding configuration
        orderMapper.insert(order);
    }
    
    public List<Order> getUserOrders(Long userId) {
        // This query will be automatically routed to the correct shard based on the user_id
        return orderMapper.selectByUserId(userId);
    }
    
    public Order getOrderById(Long orderId) {
        return orderMapper.selectById(orderId);
    }
    
}