package com.example.shardingsphere.mapper;

import com.example.shardingsphere.entity.Order;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface OrderMapper {
    
    @Insert("INSERT INTO t_order (order_id, user_id, order_no, amount, status) VALUES (#{order.orderId}, #{order.userId}, #{order.orderNo}, #{order.amount}, #{order.status})")
    int insert(@Param("order") Order order);
    
    @Select("SELECT * FROM t_order WHERE user_id = #{userId}")
    List<Order> selectByUserId(@Param("userId") Long userId);
    
    @Select("SELECT * FROM t_order WHERE order_id = #{orderId}")
    Order selectById(@Param("orderId") Long orderId);
    
}