# SpringBoot + ShardingSphere 示例项目

这是一个演示如何使用 SpringBoot 和 Apache ShardingSphere 实现数据库分库分表的示例项目。

## 概述

本示例项目展示了如何：
- 为数据库和表分片配置 ShardingSphere
- 使用 Spring Boot 与 ShardingSphere 集成
- 对分片数据实现基本的 CRUD 操作

## 先决条件

- Java 8+
- Maven 3.6+
- MySQL（包含两个数据库：db0 和 db1）

## 安装步骤

1. 创建两个 MySQL 数据库：
   ```sql
   CREATE DATABASE db0;
   CREATE DATABASE db1;
   ```

2. 如有需要，请更新 `application.yml` 中的数据库凭据

3. 构建项目：
   ```bash
   mvn clean install
   ```

4. 运行应用程序：
   ```bash
   mvn spring-boot:run
   ```

## 配置说明

`application.yml` 中的分片配置：
- 在两个数据库（ds0 和 ds1）之间分片数据
- 使用 user_id 作为分片键
- 使用哈希取模（user_id % 2）路由数据
- 创建名为 t_order_0 和 t_order_1 的表

## API 端点

- `POST /orders` - 创建新订单
- `GET /orders/user/{userId}` - 获取特定用户的所有订单
- `GET /orders/{orderId}` - 根据 ID 获取特定订单

## 主要特性

- 基于分片键的自动路由
- SQL 解析和重写
- 多数据源结果合并
- 支持分布式事务（在本基础示例中未展示）

## 架构设计

该项目演示了：
- ShardingSphere 如何拦截和路由 SQL 语句
- 数据如何在多个数据库之间分布
- 查询如何自动路由到正确的分片